(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4841,        126]*)
(*NotebookOutlinePosition[      5485,        148]*)
(*  CellTagsIndexPosition[      5441,        144]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(puntos = {{{\(-3\), 0}, {\(-3\),  .25}}, {{\(-2\), 
            0}, {\(-2\),  .75}}, {{\(-1\), 0}, {\(-1\), 1. }}, {{0, 
            0}, {0,  .25}}, {{3, 0}, {3,  .25}}, {{2, 0}, {2,  .75}}, {{1, 
            0}, {1, 1. }}, {{4, 0}, {4,  .15}}}\)], "Input"],

Cell[BoxData[
    \(valores = {{\(-3\),  .25}, {\(-2\),  .75}, {\(-1\), 
          1.0}, {0,  .25}, {3,  .25}, {2,  .75}, {1, 
          1.0}, {4,  .15}}\)], "Input"],

Cell[BoxData[
    \(Point /@ valores\)], "Input"],

Cell[BoxData[
    \(Line /@ puntos\)], "Input"],

Cell[BoxData[
    \(texto = {Text["\<a\>", {\(-3\), 0.32}, {0, \(-1\)}], 
        Text["\<b\>", {\(-2\), 0.82}, {0, \(-1\)}], 
        Text["\<c\>", {\(-1\), 1.07}, {0, \(-1\)}], 
        Text["\<d\>", {0.3, 0.4}, {0, 1}], 
        Text["\<g\>", {3, 0.32}, {0, \(-1\)}], 
        Text["\<f\>", {2, 0.82}, {0, \(-1\)}], 
        Text["\<e\>", {1, 1.07}, {0, \(-1\)}], 
        Text["\<h\>", {4,  .22}, {0, \(-1\)}], 
        Text["\<t1\>", {\(-3\), \(- .1\)}], 
        Text["\<t2\>", {\(-2\), \(- .1\)}], 
        Text["\<t3\>", {\(-1\), \(- .1\)}], Text["\<t4\>", {0.15, \(- .1\)}], 
        Text["\<t5\>", {1, \(- .1\)}], Text["\<t6\>", {2, \(- .1\)}], 
        Text["\<t7\>", {3, \(- .1\)}], 
        Text["\<t8\>", {4, \(- .1\)}]}\)], "Input"],

Cell[BoxData[
    \(graf1 = 
      Show[Graphics[{{Thickness[0.006], Line /@ puntos}, {PointSize[ .015], 
              Point /@ valores}, texto}], AspectRatio \[Rule] 1/3, 
        Axes \[Rule] True, PlotRange \[Rule] {\(- .3\), 1.2}, 
        AxesLabel \[Rule] None, Ticks \[Rule] None]\)], "Input"],

Cell[BoxData[
    \(Display["\<amplitudes.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(puntos = {{{\(-3\), 0}, {\(-3\), \(- .75\)}}, {{\(-2\), 
            0}, {\(-2\),  .25}}, {{\(-1\), 0}, {\(-1\), \(-1. \)}}, {{3, 
            0}, {3,  .75}}, {{2, 0}, {2, \(- .25\)}}, {{1, 0}, {1, 
            1. }}}\)], "Input"],

Cell[BoxData[
    \(texto = {Text["\<a\>", {\(-3\), \(-0.82\)}, {0, 1}], 
        Text["\<b\>", {\(-2\), 0.32}, {0, \(-1\)}], 
        Text["\<c\>", {\(-1\), \(-1.07\)}, {0, 1}], 
        Text["\<d\>", {0.3, 0.4}, {0, 1}], 
        Text["\<g\>", {3, 0.82}, {0, \(-1\)}], 
        Text["\<f\>", {2, \(-0.32\)}, {0, 1}], 
        Text["\<e\>", {1, 1.07}, {0, \(-1\)}], Text["\<t1\>", {\(-3\),  .1}], 
        Text["\<t2\>", {\(-2\), \(- .1\)}], Text["\<t3\>", {\(-1\),  .1}], 
        Text["\<t4\>", {0.15, \(- .1\)}], Text["\<t5\>", {1, \(- .1\)}], 
        Text["\<t6\>", {2,  .1}], Text["\<t7\>", {3, \(- .1\)}]}\)], "Input"],

Cell[BoxData[
    \(valores = {{\(-3\), \(- .75\)}, {\(-2\),  .25}, {\(-1\), \(-1.0\)}, {3, \
 .75}, {2, \(- .25\)}, {1, 1.0}}\)], "Input"],

Cell[BoxData[
    \(graf2 = 
      Show[Graphics[{{Thickness[0.006], Line /@ puntos}, {PointSize[ .015], 
              Point /@ valores}, texto}], AspectRatio \[Rule] 1/2, 
        Axes \[Rule] True, PlotRange \[Rule] {\(-1.3\), 1.3}, 
        AxesLabel \[Rule] None, Ticks \[Rule] None]\)], "Input"],

Cell[BoxData[
    \(Display["\<fases.eps\>", %, "\<EPS\>"]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 877}},
WindowSize->{1272, 843},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 277, 4, 30, "Input"],
Cell[2034, 57, 166, 3, 30, "Input"],
Cell[2203, 62, 49, 1, 30, "Input"],
Cell[2255, 65, 47, 1, 30, "Input"],
Cell[2305, 68, 747, 14, 70, "Input"],
Cell[3055, 84, 301, 5, 50, "Input"],
Cell[3359, 91, 76, 1, 30, "Input"],
Cell[3438, 94, 250, 4, 30, "Input"],
Cell[3691, 100, 626, 10, 70, "Input"],
Cell[4320, 112, 139, 2, 30, "Input"],
Cell[4462, 116, 301, 5, 50, "Input"],
Cell[4766, 123, 71, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

